﻿using System;
using System.Web;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;

namespace VIRP_WEB.Custom.EFR
{
    public partial class VTAPatient : EfrBasePage
    {
        VTA_PATIENT patient;

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                int patientId;
                //only existing referrals
                if (int.TryParse(Request.QueryString["patientId"], out patientId))
                {
                    GetRefreshVTAPatient(patientId);
                }

                SetupVTAPatient(patient);
            }
        }

        private void GetRefreshVTAPatient(int pId)
        {
            patient = VTA_PATIENTManager.GetPatientVTAInfoByPatientId(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, pId);
        }

        private void SetupVTAPatient(VTA_PATIENT vtaPatient)
        {
            SnumLabel.Text = vtaPatient.Patientsnum;
            LabelICN.Text = vtaPatient.Patienticn;
            PatientNameLabel.Text = vtaPatient.PatientName;
            Address1Label.Text = vtaPatient.PatientAddress;
            CityLabel.Text = vtaPatient.City;
            StateLabel.Text = vtaPatient.State;
            ZipCodeLabel.Text = vtaPatient.ZIP;
            CountryLabel.Text = vtaPatient.Country;
            HomePhoneLabel.Text = vtaPatient.Home_phone;
            WorkPhoneLabel.Text = vtaPatient.Work_phone;
            LabelOefOifIndicator.Text = vtaPatient.Oefoifindicator.ToString();
            if (vtaPatient.Dateofbirth.HasValue)
            {
                LabelDOB.Text = vtaPatient.Dateofbirth.Value.ToString("d");
            }
            if (vtaPatient.Dateofdeath.HasValue)
            {
                LabelDateOfDeath.Text = vtaPatient.Dateofdeath.Value.ToString("d");
            }
            LabelGenderCode.Text = vtaPatient.Gender_code;
            LabelServiceBranch.Text = vtaPatient.Svcbranch_code;
        }

        protected void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}
